/*************************************************************************
 - func uart send byte

*************************************************************************/

void func_send_byte( u8 dat )
{
    ctrl_uart_write(dat) ;/*replace this interface*/
}

/*************************************************************************
 - func uart send string

*************************************************************************/
void func_UartPutStr (const char *Str )
{
    while ( *Str)
    {
        func_send_byte ( *Str );
        *Str++;
    }
}


/*************************************************************************
 - func uart recv pro
all cmd   [start='A'] [end = 0x0A] 
*************************************************************************/
void uart_isr_recv(u8 uto_buf)
{
    g_uart_flag.uart_timeout = UART_TIMEOUT ;/*SET 100ms*/
    g_uart_flag.uart_stop  = 0; 
    buf_uart1.buf[buf_uart1.index++] = uto_buf;/*RECV BUF*/
    if(uto_buf == 0x0A)               /*recv 0x0A  over*/
    {
        g_uart_flag.uart_stop  = 1;   /*recv ok flag 1*/
        g_uart_flag.uart_analysis = 1;/*analysis this data*/          
        g_uart_flag.uart_timeout = 0 ;
        uart_recv_ok_pro(buf_uart1.buf ,buf_uart1.index) ;  /*recv over pro*/
    }
}


/*************************************************************************
 - func main
*************************************************************************/
void main()
{
    uart_init() ;/*uart init*/
    delay_2ms(500) ;/*delay 1 second*/
	func_UartPutStr("AT+CA30\r\n") ;/*set vol 30 */
    delay_2ms(500) ;/*delay 1 second*/
	func_UartPutStr("AT+CA15\r\n") ;/*set vol 15 */
    delay_2ms(500) ;/*delay 1 second*/
	func_UartPutStr("AT+BD12354678\r\n") ;/*set bt name 12345678*/
    delay_2ms(500) ;/*delay 1 second*/
	func_UartPutStr("AT+CT02\r\n") ;/*set uart baud 19200 */
    delay_2ms(500) ;/*delay 1 second*/

    while(1) ;
}